/*
 * Decompiled with CFR 0.152.
 */
package DE.siemens.ad.logo.model.block;

import DE.siemens.ad.logo.model.BinaryInBlockConnector;
import DE.siemens.ad.logo.model.Block;
import DE.siemens.ad.logo.model.BlockParameter;
import DE.siemens.ad.logo.model.InBlockConnector;
import DE.siemens.ad.logo.model.ParameterInBlockConnector;
import DE.siemens.ad.logo.model.SOutputParameter;
import DE.siemens.ad.logo.model.WiringDiagram;
import DE.siemens.ad.logo.model.block.OutputBlock;
import DE.siemens.ad.logo.util.DifferenceTableModel;
import DE.siemens.ad.logo.util.Language;
import javax.help.UnsupportedOperationException;

public class SOutputBlock
extends OutputBlock {
    private static final long serialVersionUID = 5699525378239862453L;

    public SOutputBlock() {
    }

    public SOutputBlock(WiringDiagram wiringDiagram) {
        super(wiringDiagram);
    }

    public int getNumberType() {
        return 27;
    }

    public int getResourceIndex() {
        return 27;
    }

    protected void initInConnectors() {
        this.fInConnectors = new InBlockConnector[2];
        this.fInConnectors[0] = new BinaryInBlockConnector(this, false, "1");
        String name = "DE.siemens.ad.logo.model.SOutputParameter";
        this.fInConnectors[1] = new ParameterInBlockConnector((Block)this, name, "Par");
    }

    public String getNumberPrefix() {
        return "NQ";
    }

    protected int getDefaultOrder() {
        return 10400;
    }

    public BlockParameter getParameter() {
        InBlockConnector[] connector = this.getInConnectors();
        if (connector != null) {
            for (int i = 0; i < connector.length; ++i) {
                if (!(connector[i] instanceof ParameterInBlockConnector)) continue;
                return ((ParameterInBlockConnector)connector[i]).getLinkedParameter();
            }
        } else {
            return null;
        }
        return null;
    }

    public boolean compareTo(Block otherBlock, DifferenceTableModel differences) {
        if (!super.compareTo(otherBlock, differences)) {
            return false;
        }
        SOutputParameter srcParameter = (SOutputParameter)this.getParameter();
        SOutputParameter tarParameter = (SOutputParameter)otherBlock.getParameter();
        String blockID = this.getNumberString() + " - ";
        if (!srcParameter.getAddress().equals(tarParameter.getAddress())) {
            String[] str = new String[]{blockID + Language.getString("ethernet.tcpSettingPanel.columnIPAddress", "IP Address"), String.valueOf(srcParameter.getAddress()), String.valueOf(tarParameter.getAddress())};
            Object[] o = new Object[]{this, otherBlock};
            differences.add(str, o);
            return false;
        }
        if (srcParameter.getConfiguredBlockType() != tarParameter.getConfiguredBlockType() || srcParameter.getConfiguredBlockNumber() != tarParameter.getConfiguredBlockNumber()) {
            String[] str = new String[]{blockID + Language.getString("compare.differentReferenceBlockType", "Referenced block"), srcParameter.getConfiguredBlockPrefix() + srcParameter.getConfiguredBlockNumber(), tarParameter.getConfiguredBlockPrefix() + tarParameter.getConfiguredBlockNumber()};
            Object[] o = new Object[]{this, otherBlock};
            differences.add(str, o);
            return false;
        }
        return true;
    }

    public boolean calculateBinaryValue() {
        this.fProcessImageValue = this.fValue = ((BinaryInBlockConnector)this.fInConnectors[0]).calculateBinaryValue();
        if (this.getHardware().supports("supportNetwork")) {
            this.synDigitalValueToVM(this.fProcessImageValue);
        }
        return this.fProcessImageValue;
    }

    public void endCalculation() {
        throw new UnsupportedOperationException();
    }
}

